#!/bin/sh
VER=`uname -r`
if uname -m | grep 64; then
  ARCH=amd64
else
  ARCH=i386
fi

echo "Package: egalax-multitouch-driver-$VER-$ARCH" > deb/DEBIAN/control
echo "Version: 0.4-6" >> deb/DEBIAN/control
echo "Priority: optional" >> deb/DEBIAN/control
echo "Architecture: $ARCH" >> deb/DEBIAN/control
echo "Depends: " >> deb/DEBIAN/control
echo "Maintainer: Philipp Merkel <deb@philmerk.de>" >> deb/DEBIAN/control
echo "Description: Multitouch kernel drivers for Eee PC T101 MT." >> deb/DEBIAN/control

echo '#!/bin/sh' > deb/DEBIAN/postinst
echo 'case "$1" in' >> deb/DEBIAN/postinst
echo "  configure)" >> deb/DEBIAN/postinst
echo "    depmod -a -F /boot/System.map-$VER $VER" >> deb/DEBIAN/postinst
echo "    update-initramfs -u -k $VER" >> deb/DEBIAN/postinst
echo "    if [ -f /usr/lib/X11/xorg.conf.d/97-touchscreen-calibration.conf ]; then" >> deb/DEBIAN/postinst
echo "      rm /usr/lib/X11/xorg.conf.d/97-touchscreen-calibration.conf" >> deb/DEBIAN/postinst
echo "    fi" >> deb/DEBIAN/postinst
echo "    ;;" >> deb/DEBIAN/postinst
echo "esac" >> deb/DEBIAN/postinst

echo '#!/bin/sh' > deb/DEBIAN/postrm
echo 'case "$1" in' >> deb/DEBIAN/postrm
echo "  remove|purge)" >> deb/DEBIAN/postrm
echo "    depmod -a -F /boot/System.map-$VER $VER" >> deb/DEBIAN/postrm
echo "    update-initramfs -u -k $VER" >> deb/DEBIAN/postrm
echo "    ;;" >> deb/DEBIAN/postrm
echo "esac" >> deb/DEBIAN/postrm



fakeroot dpkg-deb --build deb
FILE=egalax-multitouch-driver-$VER-$ARCH.deb
mv deb.deb $FILE
#lintian $FILE

mv $FILE ..
